ORCA/M Asm65816 2.1.0

0001 0000                       title 'Error Message File--English Version'
0002 0000
0003 0000              ;===============================================================================
0004 0000              ; Error message file.  English version.
0005 0000              ;
0006 0000              ; Copyright Apple Computer, Inc. 1988,1989.  All rights reserved.
0007 0000              ;===============================================================================
0008 0000              ;
0009 0000              ;  Modification history:
0010 0000              ;
0011 0000              ;  01-Feb-88    all     Initial release
0012 0000              ;  15-Feb-88    ADS     strings added for text mode init pack
0013 0000              ;  24-Feb-88    ADS     string 28 added
0014 0000              ;  08-Mar-88    JJ      Modified volume mount message to conform to standard
0015 0000              ;                       user interface conventions.
0016 0000              ;  31-Mar-88    JJ      Make changes to support latest definition of
0017 0000              ;                       AlertWindow
0018 0000              ;  14-Jun-88    JJ      Added system shutdown message
0019 0000              ;  12-Jul-88    JJ      Added message 34 and modified message 17.
0020 0000              ;  01-Aug-88    FAB/MSA Added message 35 'Soft Error', mod'd message 3
0021 0000              ;  25-Oct-88    BPA     Converted to MAX.
0022 0000              ;  09-Nov-88    CAE     Added messages 36 and 37 for GLoader.
0023 0000              ;  10-Nov-88    CAE     Added messages 38 and 39 for GLoader.
0024 0000              ;  08-Dec-88    CAE     Added message 40 for GLoader.
0025 0000              ;  21-Dec-88    CAE     Added string 41 for Init Manager.
0026 0000              ;  04-Jan-89    CAE     Added message 42 for GLoader.
0027 0000              ;  24 Jan 89    RBM     Added device dispatcher strings (text only)
0028 0000              ;  25-Jan-89    CAE     Commented out the graphics versions of GLoader's fatal messages
0029 0000              ;  07-Feb-89    CAE     Fixed total_size declaration
0030 0000              ;  13-Feb-89    CAE     Divided file into PERMANENT and TEMPORARY sections.
0031 0000              ;                       Moved GLoader's error messages into the TEMPORARY section.
0032 0000              ;                       Changed total_size variable to perm_size.
0033 0000              ;  17-Feb-89    MSD     Added message 47 for AppleTalk not found.
0034 0000              ;  23-Feb-89    TGH     Added messages 48-51 for server messages.
0035 0000              ;  27-Feb-89    BPA     Added message 52 for unclaimed interrupts.
0036 0000              ;  02-Mar-89    TGH     Added return values to ATALK buttons so they will be
0037 0000              ;                       displayed in the finder.  (When bit 13 of sys_prefs set.)
0038 0000              ;  14-Mar-89    CAE     Changed button return values for message 20.
0039 0000              ;                       Added messages 53 and 54 for GQuit.
0040 0000              ;  15-Mar-89    CAE     Added messages 55 and 56 for GQuit.
0041 0000              ;  28-Mar-89    CAE     Added messages 57-59 for GLoader.
0042 0000              ;  27-Apr-89    CAE     Changed "volume" to "disk" in 3 messages.
0043 0000              ;  11-May-89    CAE     Fixed length byte for m28string.
0044 0000              ;  12-May-89    TGH     Added message 60. Not enough memory for AppleTalk.
0045 0000              ;  17-May-89    CAE     Removed graphics versions of messages to save space.  
0046 0000              ;                       Adjusted text versions to work in graphics and text modes.
0047 0000              ;  18-May-89    CAE     Replaced "cr" with "space_cr" in most messages so that a
0048 0000              ;                       space will be used in graphics mode and a carriage return
0049 0000              ;                       will be used in text mode.  
0050 0000              ;                       Adjusted sizes of graphics windows.
0051 0000              ;  23-May-89    CAE     Added two QuickDraw patches at start of file.
0052 0000              ;  06-Feb-91    GAB     Added and/or modified strings used by Init Mgr.
0053 0000              ;                       Fixed patch used for inline GS/OS entry to adjust the
0054 0000              ;                         return address past the call parameters.
0055 0000              ;  26-Mar-91    GAB     Removed >65535 unclaimed interrupts message.
0056 0000              ;                       Resized Volume Mount graphics dialog.
0057 0000              ;  30-Jul-91    GAB     Added new GQuit non-fatal dialog, used when an
0058 0000              ;                         application fails the InitialLoad.
0059 0000              ;  02-Aug-91    GAB     Added new GQuit non-fatal dialog, used when a user
0060 0000              ;                         attempts to launch a P8 application from a non-
0061 0000              ;                         ProDOS and non-AppleShare volume. (Message 65)
0062 0000              ;  27-Sep-91    MSD     Added substitution string *2 to messages 48 and 49 so
0063 0000              ;                         that server shutdown messages can display the time
0064 0000              ;                         and date the server will or has shut down.
0065 0000              ;  28-Oct-91    GAB     Changed message #52 to include a substitution string
0066 0000              ;                         so that the actual error number can be displayed.
0067 0000              ;  24-Mar-92    DAL     Changed message #65 to read "disks" instead of "volumes".
0068 0000              ;  06-Apr-92    MSD     Added messages #66 (no AppleTalk hardware) and #67 (no
0069 0000              ;                         AppleTalk driver loaded).  In message #47, changed
0070 0000              ;                         "re-boot" to "restart".
0071 0000              ;  10-Feb-93    SS      Added message #68 for the RAM5 driver.
0072 0000              ;   2-Mar-93    DAL     Changed the "Untitled" default to "untitled" (for init
0073 0000              ;                       manager).
0074 0000              ;
0075 0000              ;===============================================================================
0076 0000
0077 0000              ;*******************************************************************************
0078 0000              ;
0079 0000              ;       WARNING!!               WARNING!!               WARNING!!
0080 0000              ;
0081 0000              ; This file has been divided into PERMANENT and TEMPORARY sections.
0082 0000              ; All TEMPORARY error messages are available during INITIAL boot only!!
0083 0000              ; They are not available during OS switches or after GLoader has passed 
0084 0000              ; control to GQuit to launch the startup application.
0085 0000              ; This file is now only loaded by GLoader during the initial boot.
0086 0000              ; Just before the startup application is launched, GLoader shrinks the memory
0087 0000              ; segment containing this file so that all TEMPORARY error messages are
0088 0000              ; no longer available.
0089 0000              ; This file is no longer reloaded when switching from ProDOS 8 to GS/OS.
0090 0000              ; If an error message must be available while GS/OS is operating or during an OS 
0091 0000              ; switch, the message must be placed in the PERMANENT section of this file.
0092 0000              ;
0093 0000              ;       WARNING!!               WARNING!!               WARNING!!
0094 0000              ;
0095 0000              ;*******************************************************************************
0096 0000
0097 0000
0098 0000              ;
0099 0000              ; Constants for window size descriptor (wsd).
0100 0000              ;
0101 0000
0102 0000              ws_custom equ   $30                     ;custom window size
0103 0000              ws_2small equ   $31                     ;2 lines, smallest width
0104 0000              ws_3small equ   $32                     ;3 lines, larger width
0105 0000              ws_4small equ   $33                     ;4 lines, larger width
0106 0000              ws_5small equ   $34                     ;5 lines, larger width
0107 0000              ws_2medium equ   $35                    ;2 lines, larger width
0108 0000              ws_3medium equ   $36                    ;3 lines, larger width
0109 0000              ws_4medium equ   $37                    ;4 lines, larger width
0110 0000              ws_5large equ   $38                     ;5 lines, larger width
0111 0000              ws_6large equ   $39                     ;6 lines, largest width
0112 0000
0113 0000              ;
0114 0000              ; Constants for icon descriptor (id).  Not supported by text version.
0115 0000              ;
0116 0000
0117 0000              no_icon  equ   $30
0118 0000              custom_icon equ   $31
0119 0000              stop_icon equ   $32
0120 0000              note_icon equ   $33
0121 0000              caution_icon equ   $34
0122 0000              disk_icon equ   $35
0123 0000              disk_swap_icon equ   $36
0124 0000
0125 0000              ;
0126 0000              ; Constants for standard button titles (bti) of the form *n.  Standard button
0127 0000              ; titles are supported only in the graphics version.
0128 0000
0129 0000              bt_ok    equ   $30
0130 0000              bt_cancel equ   $31
0131 0000              bt_try_again equ   $32
0132 0000              bt_yes   equ   $33
0133 0000              bt_no    equ   $34
0134 0000
0135 0000              ;
0136 0000              ; Constants for string termination characters.
0137 0000              ;
0138 0000
0139 0000              e_null   equ   $00                      ;null
0140 0000              ht       equ   $09                      ;horizontal tab
0141 0000              cr       equ   $0D                      ;carriage return
0142 0000              space_cr equ   $8D                      ;space for graphics, carriage return for text
0143 0000              esc      equ   $1B                      ;escape
0144 0000
0145 0000              ;
0146 0000              ; console driver control codes
0147 0000              ;
0148 0000
0149 0000              saveTxtPort equ   $01                   ;save the current text port
0150 0000              setTxtPortSize equ   $02                ;set the text port boundaries
0151 0000              clearBOL equ   $03                      ;clear to beginning of line
0152 0000              popTxtPort equ   $04                    ;pop text port
0153 0000              hScroll  equ   $05                      ;horizontal scroll
0154 0000              setVertPosition equ   $06               ;set vertical cursor position
0155 0000              bell     equ   $07                      ;beep!
0156 0000              backspace equ   $08                     ;backspace
0157 0000              tab      equ   $09
0158 0000              linefeed equ   $0A
0159 0000              clearEOS equ   $0B                      ;clear to end of text port
0160 0000              clearScreen equ   $0C                   ;clear textport & home cursor
0161 0000              carriageReturn equ   $0D
0162 0000              normal   equ   $0E                      ;set display format to normal
0163 0000              inverse  equ   $0F                      ;set display format to inverse
0164 0000              spaceExpansion equ   $10                ;DLE space expansion
0165 0000              column40 equ   $11                      ;set 40-column mode
0166 0000              column80 equ   $12                      ;set 80-column mode
0167 0000              clearBOS equ   $13                      ;clear to beginning of text port
0168 0000              setHorzPosition equ   $14               ;set horizontal position
0169 0000              setCursWord equ   $15                   ;set cursor movement word
0170 0000              scrollDown equ   $16                    ;scroll text down one line
0171 0000              scrollUp equ   $17                      ;scroll text up one line
0172 0000              mouseOff equ   $18                      ;disable MouseText mapping
0173 0000              homeCursor equ   $19                    ;reset cursor to upper left corner
0174 0000              clearLine equ   $1A                     ;clear current cursor line
0175 0000              mouseOn  equ   $1B                      ;enable MouseText mapping
0176 0000              cursorRight equ   $1C                   ;move cursor right
0177 0000              clearEOL equ   $1D                      ;clear to end of line
0178 0000              gotoxy   equ   $1E                      ;goto x,y
0179 0000              cursorUp equ   $1F                      ;move cursor up
0180 0000
0181 0000              ;===============================================================================
0182 0000              ; Data structure format:
0183 0000              ;
0184 0000              ; 1 word        Size of PERMANENT section of this file.
0185 0000              ;
0186 0000              ; 1 word        Number of error messages.
0187 0000              ;
0188 0000              ; 1 word        Offset of first alert string, text version.
0189 0000              ; 1 word        Offset of first alert string, graphics version.
0190 0000              ;
0191 0000              ; 1 word        Offset of second alert string, text version.
0192 0000              ; 1 word        Offset of second alert string, graphics version.
0193 0000              ; . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .
0194 0000              ;
0195 0000              ; 1 word        Offset of nth alert string, text version.
0196 0000              ;               Offset of nth alert string, graphics version.
0197 0000              ;
0198 0000              ; Alert strings have the basic format used in Task Master's AlertWindow call,
0199 0000              ; with a few additions.  The format is roughly as follows:
0200 0000              ;
0201 0000              ; wsd id \ msg \ bt1 \ bt2 \ bt3 stc r1 r2 r3
0202 0000              ;
0203 0000              ; wsd is the window size descriptor
0204 0000              ;
0205 0000              ; id is the icon descriptor
0206 0000              ;
0207 0000              ; \ is the termination character used to separate succeeding parts of the string
0208 0000              ;
0209 0000              ; msg is the main alert message string.  It may contain any character acceptable
0210 0000              ; to LETextBox2 except the termination character.  Special indicators of the
0211 0000              ; form *0, *1, ..., *9 are to be replaced by corresponding substitution strings.
0212 0000              ;
0213 0000              ; bt1, bt2, and bt3 are button titles.  Contrary to the syntax accepted by
0214 0000              ; alert_window, default button titles are not allowed in the file.
0215 0000              ;
0216 0000              ; stc (the string termination character) is either an ASCII $00 or ASCII $13
0217 0000              ;
0218 0000              ; The preceding fields are described completely in the definition of the
0219 0000              ; AlertWindow call.
0220 0000              ;
0221 0000              ; r1, r2, and r3 are the responses to be returned when the user presses the
0222 0000              ; first (left), second, or third button, respectively.  Legal values are the
0223 0000              ; ASCII codes for characters 0 through 9 (i.e. $30, $31, ..., $39).
0224 0000              ;
0225 0000              ;===============================================================================
0226 0000
0227 0000                       EXPORT error_data
0228 0000              error_data PROC 
0229 0000
0230 0000                       longa on
0231 0000                       longi on
0232 0000
0233 0000              ;*******************************************************************************
0234 0000              ;
0235 0000              ; The following 16 bytes are patches for QuickDraw.  When GQuit switches from GS/OS
0236 0000              ; to ProDOS 8, the load address of QD_patch1 is stored at the GS/OS stack entry vector
0237 0000              ; ($e1/00b0) and the load address of QD_patch2 is stored at the GS/OS normal entry
0238 0000              ; vector ($e1/00a8).  This is done so that if a ProDOS 8 application starts up 
0239 0000              ; QuickDraw (which is a legal thing to do), the QuickDraw startup routine won't crash
0240 0000              ; when it tries to make GS/OS calls (which it shouldn't be doing).  The patches are
0241 0000              ; here because they must be in a permanent, non-moveable piece of non-special memory.
0242 0000              ; The sizes of these patches are hard-coded in GLoader!  The patches MUST be the
0243 0000              ; first thing in the file and MUST be followed by "perm_size".
0244 0000              ;
0245 0000              ;*******************************************************************************
0246 0000
0247 0000              stack_entry_patch  
0248 0000 A3 01                 lda   1,s                      ;this patch is 13 bytes long
0249 0002 83 07                 sta   7,s
0250 0004 A3 02                 lda   2,s
0251 0006 83 08                 sta   8,s
0252 0008 68                    pla   
0253 0009 68                    pla   
0254 000A 68                    pla   
0255 000B 80 08                 bra   patch_exit
0256 000D
0257 000D              inline_entry_patch                      ;this patch is 13 bytes long
0258 000D 18                    clc                            ;update return address to point past ...
0259 000E A3 01                 lda   1,s                      ;... call_num and parm_block pointer
0260 0010 69 06 00              adc   #$0006                   ;since code can't cross bank boundary,
0261 0013 83 01                 sta   1,s                      ;we only need to increment low word
0262 0015
0263 0015 A9 FF 00     patch_exit lda   #$ff
0264 0018 38                    sec   
0265 0019 6B                    rtl   
0266 001A
0267 001A                       EXPORT perm_size
0268 001A A1 0E        perm_size DC W:end_of_perm_msgs-error_data
0269 001C
0270 001C                       EXPORT message_count
0271 001C 45 00        message_count DC W:(past_offset_tbl-offset_tbl)/4
0272 001E
0273 001E              ;-------------------------------------------------------------------------------
0274 001E
0275 001E                       EXPORT offset_tbl
0276 001E              offset_tbl  
0277 001E
0278 001E 14 01        m0       DC W:m0text-*
0279 0020 12 01                 DC W:m0text-*
0280 0022
0281 0022 2B 01        m1       DC W:m1text-*
0282 0024 29 01                 DC W:m1text-*
0283 0026
0284 0026 54 01        m2       DC W:m2text-*
0285 0028 52 01                 DC W:m2text-*
0286 002A
0287 002A 93 01        m3       DC W:m3text-*
0288 002C 91 01                 DC W:m3text-*
0289 002E
0290 002E 73 0E        m4       DC W:m4text-*
0291 0030 71 0E                 DC W:m4text-*
0292 0032
0293 0032 C0 0E        m5       DC W:m5text-*
0294 0034 BE 0E                 DC W:m5text-*
0295 0036
0296 0036 05 0F        m6       DC W:m6text-*
0297 0038 03 0F                 DC W:m6text-*
0298 003A
0299 003A 4D 0F        m7       DC W:m7text-*
0300 003C 4B 0F                 DC W:m7text-*
0301 003E
0302 003E 90 0F        m8       DC W:m8text-*
0303 0040 8E 0F                 DC W:m8text-*
0304 0042
0305 0042 D3 0F        m9       DC W:m9text-*
0306 0044 D1 0F                 DC W:m9text-*
0307 0046
0308 0046 2E 10        m10      DC W:m10text-*
0309 0048 2C 10                 DC W:m10text-*
0310 004A
0311 004A 6A 10        m11      DC W:m11text-*
0312 004C 68 10                 DC W:m11text-*
0313 004E
0314 004E B8 10        m12      DC W:m12text-*
0315 0050 B6 10                 DC W:m12text-*
0316 0052
0317 0052 09 11        m13      DC W:m13text-*
0318 0054 07 11                 DC W:m13text-*
0319 0056
0320 0056 AC 01        m14      DC W:m14text-*
0321 0058 AA 01                 DC W:m14text-*
0322 005A
0323 005A E4 01        m15      DC W:m15text-*
0324 005C E2 01                 DC W:m15text-*
0325 005E
0326 005E 39 02        m16      DC W:m16text-*
0327 0060 37 02                 DC W:m16text-*
0328 0062
0329 0062 4C 11        m17      DC W:m17text-*
0330 0064 4A 11                 DC W:m17text-*
0331 0066
0332 0066 7F 02        m18      DC W:m18text-*
0333 0068 7D 02                 DC W:m18text-*
0334 006A
0335 006A DB 02        m19      DC W:m19text-*
0336 006C D9 02                 DC W:m19text-*
0337 006E
0338 006E 2D 03        m20      DC W:m20text-*
0339 0070 2B 03                 DC W:m20text-*
0340 0072
0341 0072 90 03        m21      DC W:m21string-*
0342 0074 00 00                 DC W:0000
0343 0076
0344 0076 A1 03        m22      DC W:m22string-*
0345 0078 00 00                 DC W:0000
0346 007A
0347 007A A1 03        m23      DC W:m23string-*
0348 007C 00 00                 DC W:0000
0349 007E
0350 007E A8 03        m24      DC W:m24string-*
0351 0080 00 00                 DC W:0000
0352 0082
0353 0082 AB 03        m25      DC W:m25string-*
0354 0084 00 00                 DC W:0000
0355 0086
0356 0086 D7 03        m26      DC W:m26string-*
0357 0088 00 00                 DC W:0000
0358 008A
0359 008A E1 03        m27      DC W:m27string-*
0360 008C 00 00                 DC W:0000
0361 008E
0362 008E E8 03        m28      DC W:m28string-*
0363 0090 00 00                 DC W:0000
0364 0092
0365 0092 10 04        m29      DC W:m29string-*
0366 0094 00 00                 DC W:0000
0367 0096
0368 0096 1C 04        m30      DC W:m30string-*
0369 0098 00 00                 DC W:0000
0370 009A
0371 009A 1E 04        m31      DC W:m31string-*
0372 009C 00 00                 DC W:0000
0373 009E
0374 009E 34 05        m32      DC W:m32text-*
0375 00A0 32 05                 DC W:m32text-*
0376 00A2
0377 00A2 C4 05        m33      DC W:m33text-*
0378 00A4 C2 05                 DC W:m33text-*
0379 00A6
0380 00A6 4C 11        m34      DC W:m34text-*
0381 00A8 4A 11                 DC W:m34text-*
0382 00AA
0383 00AA FA 05        m35      DC W:m35text-*
0384 00AC F8 05                 DC W:m35text-*
0385 00AE
0386 00AE 96 11        m36      DC W:m36text-*
0387 00B0 94 11                 DC W:m36text-*
0388 00B2
0389 00B2 E5 11        m37      DC W:m37text-*
0390 00B4 E3 11                 DC W:m37text-*
0391 00B6
0392 00B6 32 12        m38      DC W:m38text-*
0393 00B8 30 12                 DC W:m38text-*
0394 00BA
0395 00BA 82 12        m39      DC W:m39text-*
0396 00BC 80 12                 DC W:m39text-*
0397 00BE
0398 00BE C4 12        m40      DC W:m40text-*
0399 00C0 C2 12                 DC W:m40text-*
0400 00C2
0401 00C2 25 04        m41      DC W:m41string-*
0402 00C4 00 00                 DC W:0000
0403 00C6
0404 00C6 0F 13        m42      DC W:m42text-*
0405 00C8 0D 13                 DC W:m42text-*
0406 00CA
0407 00CA 2C 06        m43      DC W:m43text-*
0408 00CC 2A 06                 DC W:m43text-*
0409 00CE
0410 00CE 8D 06        m44      DC W:m44text-*
0411 00D0 8B 06                 DC W:m44text-*
0412 00D2
0413 00D2 EC 06        m45      DC W:m45text-*
0414 00D4 EA 06                 DC W:m45text-*
0415 00D6
0416 00D6 4F 07        m46      DC W:m46text-*
0417 00D8 4D 07                 DC W:m46text-*
0418 00DA
0419 00DA 71 07        m47      DC W:m47text-*
0420 00DC 6F 07                 DC W:m47text-*
0421 00DE
0422 00DE 01 08        m48      DC W:m48text-*
0423 00E0 FF 07                 DC W:m48text-*
0424 00E2
0425 00E2 40 08        m49      DC W:m49text-*
0426 00E4 3E 08                 DC W:m49text-*
0427 00E6
0428 00E6 6F 08        m50      DC W:m50text-*
0429 00E8 6D 08                 DC W:m50text-*
0430 00EA
0431 00EA A3 08        m51      DC W:m51text-*
0432 00EC A1 08                 DC W:m51text-*
0433 00EE
0434 00EE F2 08        m52      DC W:m52text-*
0435 00F0 F0 08                 DC W:m52text-*
0436 00F2
0437 00F2 84 09        m53      DC W:m53text-*
0438 00F4 82 09                 DC W:m53text-*
0439 00F6
0440 00F6 FA 09        m54      DC W:m54text-*
0441 00F8 F8 09                 DC W:m54text-*
0442 00FA
0443 00FA 71 0A        m55      DC W:m55text-*
0444 00FC 6F 0A                 DC W:m55text-*
0445 00FE
0446 00FE D2 0A        m56      DC W:m56text-*
0447 0100 D0 0A                 DC W:m56text-*
0448 0102
0449 0102 24 13        m57      DC W:m57text-*
0450 0104 22 13                 DC W:m57text-*
0451 0106
0452 0106 6E 13        m58      DC W:m58text-*
0453 0108 6C 13                 DC W:m58text-*
0454 010A
0455 010A C1 13        m59      DC W:m59text-*
0456 010C BF 13                 DC W:m59text-*
0457 010E
0458 010E 20 0B        m60      DC W:m60text-*
0459 0110 1E 0B                 DC W:m60text-*
0460 0112
0461 0112 E5 03        m61      DC W:m61string-*               ;used by Init Mgr.
0462 0114 00 00                 DC W:0
0463 0116
0464 0116 EA 03        m62      DC W:m62string-*               ;used by Init Mgr.
0465 0118 00 00                 DC W:0
0466 011A
0467 011A 27 04        m63      DC W:m63string-*               ;used by Init Mgr.
0468 011C 00 00                 DC W:0
0469 011E
0470 011E 64 04        m64      DC W:m64string-*               ;used by Init Mgr.
0471 0120 00 00                 DC W:0
0472 0122
0473 0122
0474 0122 5C 0B        m65      DC W:m65text-*
0475 0124 5A 0B                 DC W:m65text-*
0476 0126
0477 0126 F5 0B        m66      DC W:m66text-*                 ; no AppleTalk hardware
0478 0128 F3 0B                 DC W:m66text-*
0479 012A
0480 012A 82 0C        m67      DC W:m67text-*                 ; no AppleTalk driver
0481 012C 80 0C                 DC W:m67text-*
0482 012E
0483 012E F6 0C        m68      DC W:m68text-*                 ; ROM 1 RAM disk size mismatch
0484 0130 F4 0C                 DC W:m68text-*
0485 0132
0486 0132                       EXPORT past_offset_tbl
0487 0132              past_offset_tbl  
0488 0132
0489 0132
0490 0132
0491 0132              ;===============================================================================
0492 0132              ;
0493 0132              ; Start of PERMANENT messages.
0494 0132              ;
0495 0132              ;===============================================================================
0496 0132
0497 0132              ;
0498 0132              ; Message 0:  Prints substitution strings *0 and *1 and gives Yes, No, and
0499 0132              ;             Cancel buttons
0500 0132              ;
0501 0132              m0text                                  ; 
0502 0132 37                    DC B:ws_4medium                ;4 lines, medium width
0503 0133 33                    DC B:note_icon                 ;note icon
0504 0134 5C 2A 30              DC B:'\*0'                     ;print substitution string 0
0505 0137 0D                    DC B:cr
0506 0138 2A 31 5C              DC B:'*1\'                     ;print substitution string 1
0507 013B 59 65 73 5C           DC B:'Yes\'                    ;button 0:  'Yes'
0508 013F 5E 4E 6F 5C           DC B:'^No\'                    ;button 1:  'No'
0509 0143 43 61 6E 63           DC B:'Cancel'                  ;button 2:  'Cancel'
0510 0149 00                    DC B:e_null                    ;end of alert string
0511 014A 30 31 32              DC B:'012'                     ;button response mapping
0512 014D              ;
0513 014D              ; Message 1:  Mount volume.
0514 014D              ;
0515 014D              m1text                                  ; 
0516 014D              ;	DC.B	ws_5small	;5 lines
0517 014D 35                    DC B:ws_2medium                ;? lines
0518 014E 36                    DC B:disk_swap_icon            ;disk swap icon
0519 014F
0520 014F 5C 50 6C 65           DC B:'\Please insert the disk:'
0521 0167              ;	DC.B	cr,cr
0522 0167 8D 8D                 DC B:space_cr,space_cr
0523 0169 2A 30 5C              DC B:'*0\'                     ;substitute volume name
0524 016C 43 61 6E 63           DC B:'Cancel\'                 ;right button: 'Cancel'
0525 0173 5E 4F 4B              DC B:'^OK'                     ;left button:  'OK'
0526 0176 00                    DC B:e_null                    ;end of alert string
0527 0177 31 30 30              DC B:'100'                     ;button response mapping
0528 017A              ;
0529 017A              ; Message 2:  Disk is write protected.
0530 017A              ;
0531 017A              m2text                                  ; 
0532 017A 36                    DC B:ws_3medium                ;3 lines
0533 017B 35                    DC B:disk_icon                 ;disk icon
0534 017C
0535 017C 5C 44 69 73           DC B:'\Disk *0'
0536 0184 8D                    DC B:space_cr
0537 0185 69 73 20 77           DC B:'is write protected.  Please '
0538 01A1 8D                    DC B:space_cr
0539 01A2 77 72 69 74           DC B:'write enable it.\'
0540 01B3 5E 4F 4B 5C           DC B:'^OK\'                    ;left button:  'OK'
0541 01B7 4E 6F                 DC B:'No'                      ;right button: 'No'
0542 01B9 00                    DC B:e_null                    ;end of alert string
0543 01BA 30 31 30              DC B:'010'
0544 01BD              ;
0545 01BD              ; Message 3:  Disk is damaged.
0546 01BD              ;
0547 01BD              m3text                                  ; 
0548 01BD
0549 01BD 36                    DC B:ws_3medium                ;3 lines
0550 01BE 35                    DC B:disk_icon                 ;disk icon
0551 01BF
0552 01BF 5C 44 69 73           DC B:'\Disk *0'
0553 01C7 8D                    DC B:space_cr
0554 01C8 6D 61 79 20           DC B:'may be damaged.  Please move data to'
0555 01EC 8D                    DC B:space_cr
0556 01ED 61 6E 6F 74           DC B:'another disk.\'
0557 01FB 5E 4F 4B              DC B:'^OK'                     ;left button:  'OK'
0558 01FE 00                    DC B:e_null                    ;end of alert string
0559 01FF 30 30 30              DC B:'000'
0560 0202
0561 0202              ;
0562 0202              ; Messages 4-13 are GLoader fatal error messages.
0563 0202              ; They are contained in the temporary section of this file.
0564 0202              ;
0565 0202
0566 0202              ;
0567 0202              ; Messages 14-15 are GQUIT fatal error messages.
0568 0202              ;
0569 0202              m14text                                 ;
0570 0202 35                    DC B:ws_2medium                ;2 lines, medium width
0571 0203 32                    DC B:stop_icon                 ;stop icon
0572 0204
0573 0204 5C 53 6F 72           DC B:'\Sorry, ProDOS 8 is not a compatible'
0574 0228 8D                    DC B:space_cr
0575 0229 76 65 72 73           DC B:'version.\'
0576 0232 5E 52 65 73           DC B:'^Restart'
0577 023A 00                    DC B:e_null
0578 023B 30 30 30              DC B:'000'
0579 023E
0580 023E              m15text                                 ;
0581 023E 36                    DC B:ws_3medium                ;3 lines, medium width
0582 023F 32                    DC B:stop_icon                 ;stop icon
0583 0240
0584 0240 5C 53 6F 72           DC B:'\Sorry, system error *1 occurred'
0585 0260 8D                    DC B:space_cr
0586 0261 77 68 69 6C           DC B:'while trying to run the next'
0587 027D 8D                    DC B:space_cr
0588 027E 61 70 70 6C           DC B:'application.\'
0589 028B 5E 52 65 73           DC B:'^Restart'
0590 0293 00                    DC B:e_null
0591 0294 30 30 30              DC B:'000'
0592 0297
0593 0297              m16text                                 ; 
0594 0297 36                    DC B:ws_3medium                ;3 lines, medium width
0595 0298 34                    DC B:caution_icon              ;Danger, danger
0596 0299
0597 0299 5C 44 69 73           DC B:'\Disk *0'
0598 02A1 8D                    DC B:space_cr
0599 02A2 77 61 73 20           DC B:'was prematurely ejected.'
0600 02BA 8D                    DC B:space_cr
0601 02BB 54 68 65 20           DC B:'The disk structure may be damaged.\'
0602 02DE 5E 4F 4B              DC B:'^OK'
0603 02E1 00                    DC B:e_null
0604 02E2 30 30 30              DC B:'000'
0605 02E5
0606 02E5              ;
0607 02E5              ; Message 17 is a GLoader fatal error message.
0608 02E5              ; It is contained in the temporary section of this file.
0609 02E5              ;
0610 02E5
0611 02E5              ;
0612 02E5              ; Message 18 is a GQUIT fatal error message.
0613 02E5              ;
0614 02E5              m18text                                 ;
0615 02E5 36                    DC B:ws_3medium                ;3 lines, medium width
0616 02E6 32                    DC B:stop_icon                 ;stop icon
0617 02E7
0618 02E7 5C 53 6F 72           DC B:'\Sorry, this application requires '
0619 0309 8D                    DC B:space_cr
0620 030A 74 68 65 20           DC B:'the P8 file to be in the SYSTEM '
0621 032A 8D                    DC B:space_cr
0622 032B 73 75 62 64           DC B:'subdirectory.\'
0623 0339 5E 52 65 73           DC B:'^Restart'
0624 0341 00                    DC B:e_null
0625 0342 30 30 30              DC B:'000'
0626 0345
0627 0345              ;
0628 0345              ; Message 19 - GS/OS System Error
0629 0345              ;
0630 0345              m19text                                 ;
0631 0345 37                    DC B:ws_4medium                ;4 lines, medium width
0632 0346 32                    DC B:stop_icon                 ;stop icon
0633 0347
0634 0347 5C 47 53 2F           DC B:'\GS/OS System Error'
0635 035A 0D 0D                 DC B:cr,cr
0636 035C 41 64 64 72           DC B:'Address = $*0       LC bank = $*1'
0637 037D 0D                    DC B:cr
0638 037E 45 72 72 6F           DC B:'Error code = $*2\'
0639 038F 5E 52 65 73           DC B:'^Restart'
0640 0397 00                    DC B:e_null
0641 0398 30 30 30              DC B:'000'
0642 039B              ;
0643 039B              ; Message 20 is a GQUIT non-fatal error message.
0644 039B              ;
0645 039B              m20text                                 ; 
0646 039B 36                    DC B:ws_3medium                ;3 lines, medium width
0647 039C 32                    DC B:stop_icon                 ;stop icon
0648 039D
0649 039D 5C 53 6F 72           DC B:'\Sorry, this application requires '
0650 03BF 8D                    DC B:space_cr
0651 03C0 74 68 65 20           DC B:'the P8 file to be in the SYSTEM '
0652 03E0 8D                    DC B:space_cr
0653 03E1 73 75 62 64           DC B:'subdirectory.\'
0654 03EF 52 65 73 74           DC B:'Restart\'
0655 03F7 5E 43 61 6E           DC B:'^Cancel'
0656 03FE 00                    DC B:e_null
0657 03FF 30 31 30              DC B:'010'
0658 0402
0659 0402              ;--------------------------------------------------------------------------------------
0660 0402              ;  Strings 21-31 and 61-63 are owned by the Initialization Manager.
0661 0402              ;  They are not window definitions - just strings.
0662 0402
0663 0402                       string Pascal
0664 0402 14 49 6E 69  m21string DC B:'Initialize device  .'
0665 0417
0666 0417 03 61 73 20  m22string DC B:'as '
0667 041B
0668 041B 0A 49 6E 69  m23string DC B:'Initialize'
0669 0426
0670 0426 06 43 61 6E  m24string DC B:'Cancel'
0671 042D                       string AsIs
0672 042D
0673 042D 2F           m25string DC B:m25_len
0674 042E 1E 23 32              DC B:$1e,3+32,18+32
0675 0431 53 65 6C 65           DC B:'Select: Tab '
0676 043D CA 20 CB              DC B:$ca,$20,$cb
0677 0440 20 20 43 61           DC B:'  Cancel: Esc  Initialize: '
0678 045B C1 CD                 DC B:$c1,$cd
0679 045D              m25_len  equ   *-m25string-1
0680 045D
0681 045D                       string Pascal
0682 045D 0D 20 46 69  m26string DC B:' File System '
0683 046B                       string asis
0684 046B
0685 046B 0A           m27string DC B:m27_len
0686 046C 14 3F                 DC B:$14,31+32
0687 046E 20 46 6F 72           DC B:' Format '
0688 0476              m27_len  equ   *-m27string-1
0689 0476
0690 0476                       string Pascal
0691 0476 2B 54 68 69  m28string DC B:'This file system won''t use the entire disk.'
0692 04A2
0693 04A2 0F 45 72 61  m29string DC B:'Erase device  .'
0694 04B2
0695 04B2 05 45 72 61  m30string DC B:'Erase'
0696 04B8                       string AsIs
0697 04B8
0698 04B8 2E           m31string DC B:m31_len
0699 04B9 1E 24 32              DC B:$1e,4+32,18+32
0700 04BC 53 65 6C 65           DC B:'Select: Tab '
0701 04C8 CA 20 CB              DC B:$ca,$20,$cb
0702 04CB 20 20 20 20           DC B:'    Cancel: Esc    Erase: '
0703 04E5 C1 CD                 DC B:$c1,$cd
0704 04E7              m31_len  equ   *-m31string-1
0705 04E7
0706 04E7                       string Pascal
0707 04E7 0F 49 6E 69  m41string DC B:'Initializing...'
0708 04F7
0709 04F7 08 75 6E 74  m61string DC B:'untitled'               ;default volume name for Init Mgr.
0710 0500
0711 0500 40 54 68 69  m62string DC B:'This operation will destroy all of the information on this disk.'
0712 0541
0713 0541 40 54 68 65  m63string DC B:'The supplied name is not acceptable to the selected file system.'
0714 0582
0715 0582                       string AsIs
0716 0582
0717 0582 4F           m64string DC B:m64_len
0718 0583 1E 29 23              DC B:gotoxy,9+32,3+32          ; gotoxy(9,3)
0719 0586 5F 5F 5F 5F           DC B:33,'_'                    ; 33 underlines
0720 05A7 1E 28 24              DC B:gotoxy,8+32,4+32          ; gotoxy(8,4)
0721 05AA DA 10 41 DF           DC B:$DA,spaceExpansion,33+32,$DF
0722 05AE 1E 29 25              DC B:gotoxy,9+32,5+32          ; gotoxy(9,5)
0723 05B1 CC CC CC CC           DC B:33,$CC                    ; bottom line
0724 05D2              m64_len  equ   *-m64string-1
0725 05D2
0726 05D2              ; End of Init Manager strings
0727 05D2              ;--------------------------------------------------------------------------------------
0728 05D2
0729 05D2              m32text   
0730 05D2 36                    DC B:ws_3medium                ;3 lines, medium width
0731 05D3 34                    DC B:caution_icon              ;Danger, danger
0732 05D4
0733 05D4 5C 54 68 65           DC B:'\The SCSI card in slot *0 has an old'
0734 05F8 8D                    DC B:space_cr
0735 05F9 76 65 72 73           DC B:'version ROM and cannot be used by'
0736 061A 8D                    DC B:space_cr
0737 061B 47 53 2F 4F           DC B:'GS/OS.  See your dealer for a free'
0738 063D 8D                    DC B:space_cr
0739 063E 75 70 67 72           DC B:'upgrade to the Revision C ROM...\'
0740 065F 5E 4F 4B              DC B:'^OK'
0741 0662 00                    DC B:e_null
0742 0663 30 30 30              DC B:'000'
0743 0666
0744 0666              m33text   
0745 0666
0746 0666 36                    DC B:ws_3medium                ;3 lines, medium width
0747 0667 33                    DC B:note_icon
0748 0668
0749 0668 5C 59 6F 75           DC B:'\You may now switch off your'
0750 0684 8D                    DC B:space_cr
0751 0685 41 70 70 6C           DC B:'Apple IIGS safely.\'
0752 0698 5E 52 65 73           DC B:'^Restart'
0753 06A0 00                    DC B:e_null
0754 06A1 30 30 30              DC B:'000'
0755 06A4
0756 06A4              ;
0757 06A4              ; Message 34 is a GLoader fatal error message.
0758 06A4              ; It is contained in the temporary section of this file.
0759 06A4              ;
0760 06A4
0761 06A4              ;
0762 06A4              ; Message 35:  Device Soft Error Message.
0763 06A4              ;
0764 06A4              m35text                                 ; 
0765 06A4 36                    DC B:ws_3medium                ;3 lines
0766 06A5 35                    DC B:disk_icon                 ;disk icon
0767 06A6
0768 06A6 5C 2E 2A 30           DC B:'\.*0'
0769 06AA 8D                    DC B:space_cr
0770 06AB 6D 61 79 20           DC B:'may be damaged.  Please move data to'
0771 06CF 8D                    DC B:space_cr
0772 06D0 61 6E 6F 74           DC B:'another disk. Soft Error = $*1\'
0773 06EF 5E 4F 4B              DC B:'^OK'                     ;left button:  'OK'
0774 06F2 00                    DC B:e_null                    ;end of alert string
0775 06F3 30 30 30              DC B:'000'
0776 06F6
0777 06F6              ;
0778 06F6              ; Messages 36-40 are GLoader fatal error messages.
0779 06F6              ; They are contained in the temporary section of this file.
0780 06F6              ;
0781 06F6
0782 06F6              ;  String 41 is owned by the Initialization Manager.
0783 06F6
0784 06F6              ;
0785 06F6              ; Message 42 is a GLoader fatal error message.
0786 06F6              ; It is contained in the temporary section of this file.
0787 06F6              ;
0788 06F6
0789 06F6              ;
0790 06F6              ; Message 43:  SCSI Driver must be installed to use SCSI device.
0791 06F6              ;               (displayed by device dispatcher during startup).
0792 06F6              ;
0793 06F6              m43text                                 ; 
0794 06F6 36                    DC B:ws_3medium                ;3 lines, medium width
0795 06F7 34                    DC B:caution_icon              ;caution icon
0796 06F8
0797 06F8 5C 53 43 53           DC B:'\SCSI device requires a driver.'
0798 0717 8D                    DC B:space_cr
0799 0718 50 6C 65 61           DC B:'Please install SCSI driver on'
0800 0735 8D                    DC B:space_cr
0801 0736 62 6F 6F 74           DC B:'boot disk and re-boot system.\'
0802 0754
0803 0754 5E 4F 4B              DC B:'^OK'                     ;left button:  'OK'
0804 0757 00                    DC B:e_null                    ;end of alert string
0805 0758 30 30 30              DC B:'000'
0806 075B
0807 075B              ;
0808 075B              ; Message 44:  UniDisk3.5 Driver must be installed to use UniDisk3.5 device.
0809 075B              ;               (displayed by device dispatcher during startup).
0810 075B              ;
0811 075B              m44text                                 ; 
0812 075B 36                    DC B:ws_3medium                ;3 lines, medium width
0813 075C 34                    DC B:caution_icon              ;caution icon
0814 075D
0815 075D 5C 55 6E 69           DC B:'\UniDisk3.5 requires a driver.'
0816 077B 8D                    DC B:space_cr
0817 077C 49 6E 73 74           DC B:'Install UniDisk3.5 driver on'
0818 0798 8D                    DC B:space_cr
0819 0799 62 6F 6F 74           DC B:'boot disk and re-boot system.\'
0820 07B7
0821 07B7 5E 4F 4B              DC B:'^OK'                     ;left button:  'OK'
0822 07BA 00                    DC B:e_null                    ;end of alert string
0823 07BB 30 30 30              DC B:'000'
0824 07BE
0825 07BE              ;
0826 07BE              ; Message 45:  AppleDisk3.5 Driver must be installed to use AppleDisk3.5 device.
0827 07BE              ;               (displayed by device dispatcher during startup).
0828 07BE              ;
0829 07BE              m45text                                 ; 
0830 07BE 36                    DC B:ws_3medium                ;3 lines, medium width
0831 07BF 34                    DC B:caution_icon              ;caution icon
0832 07C0
0833 07C0 5C 41 70 70           DC B:'\AppleDisk3.5 requires a driver.'
0834 07E0 8D                    DC B:space_cr
0835 07E1 49 6E 73 74           DC B:'Install AppleDisk3.5 driver on'
0836 07FF 8D                    DC B:space_cr
0837 0800 62 6F 6F 74           DC B:'boot disk and re-boot system.\'
0838 081E
0839 081E 5E 4F 4B              DC B:'^OK'                     ;left button:  'OK'
0840 0821 00                    DC B:e_null                    ;end of alert string
0841 0822 30 30 30              DC B:'000'
0842 0825              ;
0843 0825              ; Message 46:  Alternate mount volume used when no cancel allowed.
0844 0825              ;
0845 0825              m46text   
0846 0825              ;	DC.B	ws_5small	;5 lines
0847 0825 35                    DC B:ws_2medium                ;? lines
0848 0826 36                    DC B:disk_swap_icon            ;disk swap icon
0849 0827
0850 0827 5C 50 6C 65           DC B:'\Please insert the disk:'
0851 083F              ;	DC.B	cr,cr
0852 083F 8D 8D                 DC B:space_cr,space_cr
0853 0841 2A 30 5C              DC B:'*0\'                     ;substitute volume name
0854 0844 5E 4F 4B              DC B:'^OK'                     ;left button:  'OK'
0855 0847 00                    DC B:e_null                    ;end of alert string
0856 0848 30 30 30              DC B:'000'                     ;button response mapping
0857 084B
0858 084B              ;
0859 084B              ; Message 47:  AppleShare must be installed for AppleShare.FST.
0860 084B              ;
0861 084B              m47text                                 ; 
0862 084B 36                    DC B:ws_3medium                ;3 lines, medium width
0863 084C 34                    DC B:caution_icon              ;caution icon
0864 084D
0865 084D 5C 41 70 70           DC B:'\AppleShare.FST requires AppleShare.'
0866 0871 8D                    DC B:space_cr
0867 0872 50 6C 65 61           DC B:'Please enable AppleTalk in the'
0868 0890 8D                    DC B:space_cr
0869 0891 43 6F 6E 74           DC B:'Control Panel, install AppleShare on'
0870 08B5 8D                    DC B:space_cr
0871 08B6 74 68 65 20           DC B:'the boot disk and restart system.\'
0872 08D8
0873 08D8 5E 4F 4B              DC B:'^OK'                     ;left button:  'OK'
0874 08DB 00                    DC B:e_null                    ;end of alert string
0875 08DC 30 30 30              DC B:'000'
0876 08DF
0877 08DF              ;
0878 08DF              ; Message 48:  The file server *0 is closing down in *1 minute(s).
0879 08DF              ;
0880 08DF              m48text                                 ; 
0881 08DF 37                    DC B:ws_4medium                ;4 lines, medium width
0882 08E0 33                    DC B:note_icon
0883 08E1 5C 54 68 65           DC B:'\The file server'
0884 08F1 8D                    DC B:space_cr
0885 08F2 2A 30                 DC B:'*0'
0886 08F4 8D                    DC B:space_cr
0887 08F5 69 73 20 63           DC B:'is closing down in *1 minute(s).'
0888 0915 0D                    DC B:cr
0889 0916 5B 2A 32 5D           DC B:'[*2]\'
0890 091B 5E 4F 4B              DC B:'^OK'                     ;button: 'OK'
0891 091E 00                    DC B:e_null                    ;end of message
0892 091F 31 30 30              DC B:'100'
0893 0922
0894 0922              ;
0895 0922              ; Message 49:  The file server *0 has closed down.
0896 0922              ;
0897 0922              m49text                                 ; 
0898 0922 37                    DC B:ws_4medium                ;4 lines, medium width
0899 0923 33                    DC B:note_icon
0900 0924 5C 54 68 65           DC B:'\The file server'
0901 0934 8D                    DC B:space_cr
0902 0935 2A 30                 DC B:'*0'
0903 0937 8D                    DC B:space_cr
0904 0938 68 61 73 20           DC B:'has closed down.'
0905 0948 0D                    DC B:cr
0906 0949 5B 2A 32 5D           DC B:'[*2]\'
0907 094E 5E 4F 4B              DC B:'^OK'                     ;button: 'OK'
0908 0951 00                    DC B:e_null                    ;end of message
0909 0952 31 30 30              DC B:'100'
0910 0955
0911 0955              ;
0912 0955              ; Message 50:  The file server *0 is no longer closing down.
0913 0955              ;
0914 0955              m50text                                 ; 
0915 0955 36                    DC B:ws_3medium                ;3 lines, medium width
0916 0956 33                    DC B:note_icon
0917 0957 5C 54 68 65           DC B:'\The file server'
0918 0967 8D                    DC B:space_cr
0919 0968 2A 30                 DC B:'*0'
0920 096A 8D                    DC B:space_cr
0921 096B 69 73 20 6E           DC B:'is no longer closing down.\'
0922 0986 5E 4F 4B              DC B:'^OK'                     ;button: 'OK'
0923 0989 00                    DC B:e_null                    ;end of message
0924 098A 31 30 30              DC B:'100'
0925 098D
0926 098D              ;
0927 098D              ; Message 51:  The connection to the file server *0 has unexpectedly closed down.
0928 098D              ;
0929 098D              m51text                                 ; 
0930 098D 36                    DC B:ws_3medium                ;3 lines, medium width
0931 098E 33                    DC B:note_icon
0932 098F 5C 54 68 65           DC B:'\The connection to the file server'
0933 09B1 8D                    DC B:space_cr
0934 09B2 2A 30                 DC B:'*0'
0935 09B4 8D                    DC B:space_cr
0936 09B5 68 61 73 20           DC B:'has unexpectedly closed down.\'
0937 09D3 5E 43 6F 6E           DC B:'^Continue'               ;button: 'OK'
0938 09DC 00                    DC B:e_null                    ;end of message
0939 09DD 31 30 30              DC B:'100'
0940 09E0
0941 09E0              ;
0942 09E0              ; Message 52:  GQuit - Unable to run next application
0943 09E0              ;
0944 09E0              ;           '          1         2         3         '
0945 09E0              ;           '0123456789012345678901234567890123456789'
0946 09E0              m52text   
0947 09E0 36                    DC B:ws_3medium                ;3 lines, medium width
0948 09E1 34                    DC B:caution_icon              ;caution icon
0949 09E2
0950 09E2 5C                    DC B:'\'
0951 09E3 53 6F 72 72           DC B:'Sorry, system error $*0 occurred'
0952 0A03 8D                    DC B:space_cr
0953 0A04 77 68 69 6C           DC B:'while trying to run the next '
0954 0A21 8D                    DC B:space_cr
0955 0A22 61 70 70 6C           DC B:'application.  Return to launching'
0956 0A43 8D                    DC B:space_cr
0957 0A44 61 70 70 6C           DC B:'application or restart system?\'
0958 0A63 52 65 73 74           DC B:'Restart\'
0959 0A6B 5E 52 65 74           DC B:'^Return'
0960 0A72 00                    DC B:e_null
0961 0A73 30 31 30              DC B:'010'
0962 0A76
0963 0A76              ;
0964 0A76              ; Messages 53 - 55 are GQUIT non-fatal error messages.
0965 0A76              ;
0966 0A76              m53text                                 ; 
0967 0A76 36                    DC B:ws_3medium                ;3 lines, medium width
0968 0A77 34                    DC B:caution_icon              ;caution icon
0969 0A78
0970 0A78 5C 57 61 72           DC B:'\Warning, this application may not '
0971 0A9B 8D                    DC B:space_cr
0972 0A9C 72 75 6E 20           DC B:'run correctly since its pathname is '
0973 0AC0 8D                    DC B:space_cr
0974 0AC1 6C 6F 6E 67           DC B:'longer than 64 characters.\'
0975 0ADC 43 6F 6E 74           DC B:'Continue\'
0976 0AE5 5E 43 61 6E           DC B:'^Cancel'
0977 0AEC 00                    DC B:e_null
0978 0AED 31 32 30              DC B:'120'
0979 0AF0
0980 0AF0              m54text                                 ; 
0981 0AF0 36                    DC B:ws_3medium                ;3 lines, medium width
0982 0AF1 34                    DC B:caution_icon              ;caution icon
0983 0AF2
0984 0AF2 5C 57 61 72           DC B:'\Warning, this application may not '
0985 0B15 8D                    DC B:space_cr
0986 0B16 72 75 6E 20           DC B:'run correctly since its pathname is '
0987 0B3A 8D                    DC B:space_cr
0988 0B3B 6C 6F 6E 67           DC B:'longer than 64 characters.\'
0989 0B56 52 65 73 74           DC B:'Restart\'
0990 0B5E 5E 43 6F 6E           DC B:'^Continue'
0991 0B67 00                    DC B:e_null
0992 0B68 30 31 30              DC B:'010'
0993 0B6B
0994 0B6B              m55text                                 ; 
0995 0B6B 36                    DC B:ws_3medium                ;3 lines, medium width
0996 0B6C 32                    DC B:stop_icon                 ;stop icon
0997 0B6D
0998 0B6D 5C 53 6F 72           DC B:'\Sorry, this application cannot '
0999 0B8D 8D                    DC B:space_cr
1000 0B8E 62 65 20 6C           DC B:'be launched because its pathname '
1001 0BAF 8D                    DC B:space_cr
1002 0BB0 69 73 20 74           DC B:'is too long.\'
1003 0BBD 52 65 73 74           DC B:'Restart\'
1004 0BC5 5E 43 61 6E           DC B:'^Cancel'
1005 0BCC 00                    DC B:e_null
1006 0BCD 30 31 30              DC B:'010'
1007 0BD0
1008 0BD0              ;
1009 0BD0              ; Message 56 is a GQUIT fatal error message.
1010 0BD0              ;
1011 0BD0              m56text                                 ; 
1012 0BD0 36                    DC B:ws_3medium                ;3 lines, medium width
1013 0BD1 32                    DC B:stop_icon                 ;stop icon
1014 0BD2
1015 0BD2 5C 53 6F 72           DC B:'\Sorry, this application cannot '
1016 0BF2 8D                    DC B:space_cr
1017 0BF3 62 65 20 6C           DC B:'be launched because its pathname '
1018 0C14 8D                    DC B:space_cr
1019 0C15 69 73 20 74           DC B:'is too long.\'
1020 0C22 5E 52 65 73           DC B:'^Restart'
1021 0C2A 00                    DC B:e_null
1022 0C2B 30 30 30              DC B:'000'
1023 0C2E
1024 0C2E              ;
1025 0C2E              ; Messages 57-59 are GLoader fatal error messages.
1026 0C2E              ; They are contained in the temporary section of this file.
1027 0C2E              ;
1028 0C2E
1029 0C2E              ;
1030 0C2E              ; Message 60:  Not enouph memory to load AppleTalk. AppleTalk will not be avaiable.
1031 0C2E              ;
1032 0C2E              m60text                                 ; 
1033 0C2E 36                    DC B:ws_3medium                ;4 lines, medium width
1034 0C2F 33                    DC B:note_icon
1035 0C30 5C 4E 6F 74           DC B:'\Not enough memory to load AppleTalk.'
1036 0C55 8D                    DC B:space_cr
1037 0C56 41 70 70 6C           DC B:'AppleTalk will not be available.\'
1038 0C77 5E 4F 4B              DC B:'^OK'                     ;button: 'OK'
1039 0C7A 00                    DC B:e_null                    ;end of message
1040 0C7B 31 30 30              DC B:'100'
1041 0C7E
1042 0C7E              ;
1043 0C7E              ; Message 65:  GQuit non-fatal message - Can't launch P8 apps from HFS volumes, fool!
1044 0C7E              ;
1045 0C7E              ;           '          1         2         3         '
1046 0C7E              ;           '0123456789012345678901234567890123456789'
1047 0C7E              m65text   
1048 0C7E 36                    DC B:ws_3medium                ;3 lines, medium width
1049 0C7F 34                    DC B:caution_icon              ;caution icon
1050 0C80
1051 0C80 5C                    DC B:'\'
1052 0C81 53 6F 72 72           DC B:'Sorry, ProDOS 8 applications can only'
1053 0CA6 8D                    DC B:space_cr
1054 0CA7 62 65 20 6C           DC B:'be launched from ProDOS or AppleShare'
1055 0CCC 8D                    DC B:space_cr
1056 0CCD 64 69 73 6B           DC B:'disks.  Return to launching'
1057 0CE8 8D                    DC B:space_cr
1058 0CE9 61 70 70 6C           DC B:'application or restart system?\'
1059 0D08 52 65 73 74           DC B:'Restart\'
1060 0D10 5E 52 65 74           DC B:'^Return'
1061 0D17 00                    DC B:e_null
1062 0D18 30 31 30              DC B:'010'
1063 0D1B
1064 0D1B              ;
1065 0D1B              ; Message 66:  AppleTalk hardware couldn't be found.
1066 0D1B              ;
1067 0D1B              m66text   
1068 0D1B 36                    DC B:ws_3medium                ;3 lines, medium width
1069 0D1C 34                    DC B:caution_icon              ;caution icon
1070 0D1D
1071 0D1D 5C                    DC B:'\'
1072 0D1E 54 68 65 20           DC B:'The selected AppleTalk connection'
1073 0D3F 8D                    DC B:space_cr
1074 0D40 63 6F 75 6C           DC B:'could not be found.  Be sure it is'
1075 0D62 8D                    DC B:space_cr
1076 0D63 69 6E 73 74           DC B:'installed and the slot settings in the'
1077 0D89 8D                    DC B:space_cr
1078 0D8A 43 6F 6E 74           DC B:'Control Panel are correct.\'
1079 0DA5 5E 4F 4B              DC B:'^OK'
1080 0DA8 00                    DC B:e_null
1081 0DA9 31 30 30              DC B:'100'
1082 0DAC
1083 0DAC              ;
1084 0DAC              ; Message 67:  AppleTalk driver couldn't be found.
1085 0DAC              ;
1086 0DAC              m67text   
1087 0DAC 36                    DC B:ws_3medium                ;3 lines, medium width
1088 0DAD 34                    DC B:caution_icon              ;caution icon
1089 0DAE
1090 0DAE 5C                    DC B:'\'
1091 0DAF 41 20 64 72           DC B:'A driver for the selected AppleTalk'
1092 0DD2 8D                    DC B:space_cr
1093 0DD3 63 6F 6E 6E           DC B:'connection could not be found.  Be'
1094 0DF5 8D                    DC B:space_cr
1095 0DF6 73 75 72 65           DC B:'sure it is installed and then restart.\'
1096 0E1D 5E 4F 4B              DC B:'^OK'
1097 0E20 00                    DC B:e_null
1098 0E21 31 30 30              DC B:'100'
1099 0E24
1100 0E24              ;
1101 0E24              ; Message 68:  RAM5 driver found a mismatch in Min/Max sizes on a ROM 1
1102 0E24              ;
1103 0E24              m68text   
1104 0E24 36                    DC B:ws_3medium                ;3 lines, medium width
1105 0E25 34                    DC B:caution_icon              ;caution icon
1106 0E26
1107 0E26 5C                    DC B:'\'
1108 0E27 46 6F 72 20           DC B:'For faster RAM5 speed, make the'
1109 0E46 8D                    DC B:space_cr
1110 0E47 6D 69 6E 69           DC B:'minimum and maximum RAM Disk sizes'
1111 0E69 8D                    DC B:space_cr
1112 0E6A 74 68 65 20           DC B:'the same in the Control Panel and'
1113 0E8B 8D                    DC B:space_cr
1114 0E8C 74 68 65 6E           DC B:'then restart.\'
1115 0E9A 5E 4F 4B              DC B:'^OK'
1116 0E9D 00                    DC B:e_null
1117 0E9E 31 30 30              DC B:'100'
1118 0EA1
1119 0EA1                       EXPORT end_of_perm_msgs
1120 0EA1              end_of_perm_msgs  
1121 0EA1
1122 0EA1              ;===============================================================================
1123 0EA1              ;
1124 0EA1              ; End of PERMANENT messages.
1125 0EA1              ;
1126 0EA1              ;===============================================================================
